
/* an HDOS directory entry is this many bytes long	*/

#define HDOS_ENTRY_SIZE		23

#define HDOS_ENTRY_UNUSED(b)		((b)->name[0] == 0xff)
#define HDOS_ENTRY_UNUSED_LAST(b)	((b)->name[0] == 0xfe)

#define HDOS_MARK_ENTRY_UNUSED(b)	((b)->name[0] = 0xff)
#define HDOS_MARK_ENTRY_UNUSED_LAST(b)	((b)->name[0] = 0xff)

#define HDOS_FLAGS_SYSTEM_BITS	0x80
#define HDOS_FLAGS_LOCKED_BITS	0x40
#define HDOS_FLAGS_WP_BITS	0x20
#define HDOS_FLAGS_CONTIG_BITS	0x10

#define HDOS_FLAGS_SYSTEM(c)	((c)&HDOS_FLAGS_SYSTEM_BITS)
#define HDOS_FLAGS_LOCKED(c)	((c)&HDOS_FLAGS_LOCKED_BITS)
#define HDOS_FLAGS_WP(c)	((c)&HDOS_FLAGS_WP_BITS)
#define HDOS_FLAGS_CONTIG(c)	((c)&HDOS_FLAGS_CONTIG_BITS)

typedef int	hdos_inode;

struct hdos_dirent {
    unsigned char	name[8];	/* filename, padded on right	*/
    unsigned char	ext[3];		/* extention, padded on right	*/
    int			project;	/* may be unused at this point	*/
    int			version;	/* also unused			*/
    int			cluster;	/* cluster factor		*/
    int			flags;		/* 0x80 = system, 0x40 = locked	*/
    					/* 0x20 = wp, 0x10 = contig	*/
    int			is_system;	/* Booleans set by flags	*/
    int			is_locked;	/* ""				*/
    int			is_wp;		/* ""				*/
    int			is_contig;	/* ""				*/
    int			reserved;	/* unused			*/
    int			firstgroup;	/* first group number		*/
    int			lastgroup;	/* last group number		*/
    int			lastsecidx;	/* last sec index (in last grp)	*/
    struct hdos_date	create;		/* file creation date		*/
    struct hdos_date	mod;		/* file modification date	*/
};

struct hdos_dirblock {
    int			entrylen;	/* this will be 23	*/
    int			this;		/* this logical sector number	*/
    int			next;		/* next logical sector number	*/
					/* (next will be zero on last)	*/
    int			entries;	/* number of dir entries (22)	*/
    struct hdos_dirent	entry[22];	/* space for entries		*/
};

struct hdos_dir {
    int				blocks;		/* num of blocks used	*/
    int				maxblocks;	/* num of blocks alloc'd*/ 
    struct hdos_dirblock	*block;		/* block storage	*/

};

/*
 * and "INODE" is a unique identifier for an entry in the
 * filesystem.  For this code, it is simply the directory block
 * number along with the entry within that block.  The INODE
 * is just an int with the two put together.
 */

#define HDOS_INODE(i,j)		((hdos_inode)((i<<8)+j))

/*
 * a "NULL" inode is one that can't be reached within a directory
 * -1 is chosen becuase this can't happen in HDOS.  The following
 * was the previous definition, though this was simply overkill:
 * #define HDOS_INODE_NULL(h)	((h)->blocks<<8&(h)->block[0].entries) 
 */
#define HDOS_INODE_NULL		((hdos_inode)-1)

#define HDOS_INODE_BLOCK(i)	((int)(((i)>>8)&0xff))
#define HDOS_INODE_ENTRY(i)	((int)((i)&0xff))

struct hdosfs;

extern void hdos_dir_init(struct hdos_dir *);
extern void hdos_dir_cleanup(struct hdos_dir *);

extern struct hdos_dirent *hdos_dirent(struct hdosfs *, hdos_inode);
